/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(sin(time*0.77777),sin(time*0.55555))
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;
// uniform vec2 mouse;
// uniform vec2 resolution;
// varying vec2 surfacePosition;

const float maxi = 1000.0;

vec2 csq(vec2 z) {
	return vec2(z.x*z.x-z.y*z.y,2.0*z.x*z.y);
}

void main( void ) {

	vec2 Z = vec2(0.0);
	vec2 C = surfacePosition * 8.0; C.y *= -1.0;
	vec2 Z1 = C;
	
	float t = maxi;
	float dr = 0.0;
	
	for (float i = 0.0; i < maxi; ++i)
	{
		dr += length(Z1 - Z);
		
		Z = Z1;
		Z1 = csq(abs(Z)) + C;
		
		if (dot(Z,Z) > 12.25)
		{
			t = i;
			break;
		}
	}
	
	float st = sin(time);
	float it = (1.0 - exp( 0.5 * st - log(dr / t))) * exp( - log(dr / t));
	
	gl_FragColor = vec4( 1.53 * it, 1.95 * it / (st + 2.0), 1.44 * it, 1.0 );
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}